const mongoose = require("mongoose");
const validator = require("validator");

const newslatterSchema = new mongoose.Schema(
  {
    email: {
      type: String,
      required: [true, "Please provide your email"],
      lowercase: true,
      validate: [validator.isEmail, "Please provide a valid email"],
    },
    createdAt: {
      type: Date,
      default: Date.now(),
    },
  },
  {
    toJSON: { virtuals: true },
    toObject: { virtuals: true },
  }
);

formtSchema.pre("save", function (next) {
  this.createdAt = Date.now();
  next();
});
const Form = mongoose.model("Form", newslatterSchema);

module.exports = Form;
