document.addEventListener("DOMContentLoaded", function () {
    const menu = document.querySelector("#menu");
    const openBtn = document.querySelector("#menu-open");
    const closeBtn = document.querySelector("#menu-close");
  
    // Open Menu
    openBtn.addEventListener("click", function () {
        openBtn.classList.add("hidden")
      menu.classList.remove("-translate-x-full", "opacity-0");
      menu.classList.add("translate-x-0", "opacity-100");
    });
  
    // Close Menu
    closeBtn.addEventListener("click", function () {
        openBtn.classList.remove("hidden")
      menu.classList.remove("translate-x-0", "opacity-100");
      menu.classList.add("-translate-x-full", "opacity-0");
    });
  
    // Close menu when clicking outside
    document.addEventListener("click", function (event) {
      if (!menu.contains(event.target) && !openBtn.contains(event.target)) {
        openBtn.classList.remove("hidden")
        menu.classList.add("-translate-x-full", "opacity-0");
        menu.classList.remove("translate-x-0", "opacity-100");
      }
    });
  });


// Slider
// Select elements
const slider = document.querySelector('.slider');
const slides = document.querySelectorAll('.slide');
const prevBtn = document.querySelector('.prev');
const nextBtn = document.querySelector('.next');

let index = 0;
let totalSlides = slides.length;
let slidesPerView = getSlidesPerView();
let isDragging = false;
let startX = 0;
let currentTranslate = 0;
let prevTranslate = 0;

// Return the width of one slide (dynamically)
function getSlideWidth() {
  return slides[0]?.clientWidth || 0;
}

// Determine how many slides are visible based on breakpoints
function getSlidesPerView() {
  if (window.innerWidth >= 1290) return 3;
  if (window.innerWidth >= 1050) return 2;
  return 1;
}

// Update the slider’s position (using CSS transform) based on the current index
function updatePosition(instant = false) {
  slidesPerView = getSlidesPerView();
  const slideWidth = getSlideWidth();
  const maxIndex = Math.max(totalSlides - slidesPerView, 0);
  if (index > maxIndex) index = maxIndex;
  if (index < 0) index = 0;
  
  // Calculate the translateX value
  const translateX = -index * slideWidth;
  slider.style.transition = instant ? "none" : "transform 0.4s ease-in-out";
  slider.style.transform = `translateX(${translateX}px)`;
  
  // Update our tracking variables
  prevTranslate = translateX;
  currentTranslate = translateX;
}

// Move slide via button click (next or prev)
function moveSlide(direction) {
  const maxIndex = Math.max(totalSlides - slidesPerView, 0);
  if (direction === 'next' && index < maxIndex) {
    index++;
  } else if (direction === 'prev' && index > 0) {
    index--;
  }
  updatePosition();
}

nextBtn.addEventListener('click', () => moveSlide('next'));
prevBtn.addEventListener('click', () => moveSlide('prev'));

// When dragging starts, record the starting position and remove any transition
function onDragStart(event) {
  isDragging = true;
  startX = event.type.includes('mouse')
    ? event.pageX
    : event.touches[0].clientX;
  // Use currentTranslate as starting translation
  prevTranslate = currentTranslate;
  slider.style.transition = "none";
  slider.classList.add('dragging');
}

// While dragging, update the translation based on movement and clamp it
function onDragMove(event) {
  if (!isDragging) return;
  const currentX = event.type.includes('mouse')
    ? event.pageX
    : event.touches[0].clientX;
  const delta = currentX - startX;
  const slideWidth = getSlideWidth();
  const maxTranslate = -(totalSlides - slidesPerView) * slideWidth;
  currentTranslate = prevTranslate + delta;
  
  // Clamp currentTranslate so we don’t drag too far left/right
  if (currentTranslate > 0) currentTranslate = 0;
  if (currentTranslate < maxTranslate) currentTranslate = maxTranslate;
  
  slider.style.transform = `translateX(${currentTranslate}px)`;
}

// When dragging ends, check the distance dragged and update the index if needed
function onDragEnd(event) {
  if (!isDragging) return;
  isDragging = false;
  slider.classList.remove('dragging');
  
  const endX = event.type.includes('mouse')
    ? event.pageX
    : event.changedTouches[0].clientX;
  const delta = endX - startX;
  const slideWidth = getSlideWidth();
  const threshold = slideWidth / 3; // Half the slide width as threshold
  
  // If drag distance exceeds threshold, update the index
  if (Math.abs(delta) >= threshold) {
    if (delta < 0 && index < (totalSlides - slidesPerView)) {
      index++; // Dragged left: go to next slide
    } else if (delta > 0 && index > 0) {
      index--; // Dragged right: go to previous slide
    }
  }
  
  // Snap to the updated slide
  updatePosition();
}

// Attach mouse and touch events
slider.addEventListener('mousedown', onDragStart);
slider.addEventListener('mousemove', onDragMove);
window.addEventListener('mouseup', onDragEnd);
slider.addEventListener('touchstart', onDragStart);
slider.addEventListener('touchmove', onDragMove);
slider.addEventListener('touchend', onDragEnd);

// Prevent images from being dragged by default
document.querySelectorAll('.slide img').forEach(img => (img.draggable = false));

// Update slider on window resize
window.addEventListener('resize', () => updatePosition(true));

// Initialize slider position
updatePosition();






 //* accordion 
  const plusSVG = `
    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" viewBox="0 0 16 16" fill="currentColor">
      <path d="M8.75 3.75a.75.75 0 0 0-1.5 0v3.5h-3.5a.75.75 0 0 0 0 1.5h3.5v3.5a.75.75 0 0 0 1.5 0v-3.5h3.5a.75.75 0 0 0 0-1.5h-3.5v-3.5Z" />
    </svg>`;
    
  const minusSVG = `
    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" viewBox="0 0 16 16" fill="currentColor">
      <path d="M3.75 7.25a.75.75 0 0 0 0 1.5h8.5a.75.75 0 0 0 0-1.5h-8.5Z" />
    </svg>`;

  document.querySelectorAll('.accordion-group').forEach(group => {
    const toggles = group.querySelectorAll('.accordion-toggle');

    toggles.forEach(toggle => {
      toggle.addEventListener('click', () => {
        const currentContent = toggle.nextElementSibling;
        const currentIcon = toggle.querySelector('.accordion-icon');

        group.querySelectorAll('.accordion-content').forEach(content => {
          if (content !== currentContent) {
            content.style.maxHeight = '0';
          }
        });

        group.querySelectorAll('.accordion-icon').forEach(icon => {
          if (icon !== currentIcon) {
            icon.innerHTML = plusSVG;
          }
        });

        if (currentContent.style.maxHeight && currentContent.style.maxHeight !== '0px') {
          currentContent.style.maxHeight = '0';
          currentIcon.innerHTML = plusSVG;
        } else {
          currentContent.style.maxHeight = currentContent.scrollHeight + 'px';
          currentIcon.innerHTML = minusSVG;
        }
      });
    });
  });

 