const mongoose = require("mongoose");
const categorySchema = new mongoose.Schema(
  {
    name: {
      type: String,
      required: [true, "لطفا نام دسته بندی را وارد کنید"],
      lowercase: true,
    },
    createdAt: {
      type: Date,
      default: Date.now(),
    },
    description: { type: String },
    mainText: { type: String },
    tree: {
      type: String,

      unique: [true, "این دسته قبلا ساخته شده است"],
      required: [true, "لطفا شاخه محتوا را تعیین کنید."],
    },
  },
  {
    toJSON: { virtuals: true },
    toObject: { virtuals: true },
  }
);

categorySchema.pre("save", function (next) {
  this.createdAt = Date.now();
  next();
});
const CategorySchema = mongoose.model("category", categorySchema);

module.exports = CategorySchema;
